<?php
    /*
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    $cerca   = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 100;
    
    $parametriRicerca = array("nome"=>$cerca);
    $parametri = array("tabella"=>"geecAd_risorse", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);

    $ricerca    = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"gestioneRisorse.php");
?>

    <input type="text" class="d-none" name="operazione" value="aggiornaImpostazioniGenerali">
    <h4 class="mb-4 title">File scaricabili</h4>

    <a href="../controller/controllerRisorse.php?operazione=creaFileScaricabile&id=0" class="btn btn-sm btn-primary mb-3" >
        Aggiungi nuovo<i class="fas fa-plus ml-2"></i>
    </a>

    <div class="d-flex justify-content-between mb-3">
        <?php
            $ricerca->stampaSelectNumeroElementi($cerca);
            $ricerca->stampaFormRicerca($cerca);
        ?>
    </div>
    <div class="table-responsive table-sm">
        <?php
            $colonne = array("ID","Nome","Descrizione","Categoria","Ultimo aggiornamento","Numero download","Azioni");
            $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);

            $risRisorse = $ricerca->eseguiRicerca(1);
            while($risorsa = $risRisorse->fetch_assoc()) {
                $nomeEscape = filter_var($risorsa["nome"], FILTER_SANITIZE_ADD_SLASHES);
                $azioni     = array("modifica"=>"creaFileScaricabile.php?id={$risorsa["id"]}","elimina"=>"eliminaFileScaricabile({$risorsa["id"]},'$nomeEscape')");
                if($risorsa["categoria"]==0) {
                    $nomeCategoria = "";
                }
                else {
                    $categoriaRisorsa = $geecomDb->leggiSingolaRiga("geec_categorie",$risorsa["categoria"]);
                    $nomeCategoria    = $categoriaRisorsa["nome"];
                }
                $tabella->aggiungiNuovaRiga(array($risorsa["id"],"<a href=creaFileScaricabile.php?id={$risorsa["id"]}><b>{$risorsa["nome"]}</b></a>",$risorsa["descrizione"],$nomeCategoria,date("d/m/Y",strtotime($risorsa["dataCreazione"])),$risorsa["numeroDownload"]),$azioni);
            }
            $tabella->stampa("fileScaricabile",0);
        ?>
    </div>